unit MainUnit;

//   .   Font   TextOut

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Menus, ExtCtrls;

type
  TForm1 = class(TForm)
    ColorDialog1: TColorDialog;
    FontDialog1: TFontDialog;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    N5: TMenuItem;
    Label1: TLabel;
    EditPicTxt: TEdit;
    STxtFontName: TStaticText;
    Label2: TLabel;
    STxtColor: TStaticText;
    STxtWidth: TStaticText;
    STxtHeigth: TStaticText;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    procedure FormPaint(Sender: TObject);
    procedure N3Click(Sender: TObject);
    procedure N4Click(Sender: TObject);
    procedure N5Click(Sender: TObject);
    procedure EditPicTxtChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

//   
procedure TForm1.FormPaint(Sender: TObject);
begin
 Canvas.TextOut(40,60, EditPicTxt.Text);
end;

// 
procedure TForm1.N3Click(Sender: TObject);
begin
  Close;
end;

//   
procedure TForm1.N4Click(Sender: TObject);
begin
  if ColorDialog1.Execute
  then begin
    Canvas.Font.Color:=ColorDialog1.Color;
    //   
    STxtColor.Color := Canvas.Font.Color;
  end;
  FormPaint(nil);
end;

//   
procedure TForm1.N5Click(Sender: TObject);
begin
  if FontDialog1.Execute
  then begin
     //  
     Canvas.Font:=FontDialog1.Font;
     Canvas.Font.Color := STxtColor.Color;
     //   
     STxtFontName.Caption := Canvas.Font.Name;
     STxtWidth.Caption := IntToStr(Canvas.TextWidth(EditPicTxt.Text));
     STxtHeigth.Caption := IntToStr(Canvas.TextHeight(EditPicTxt.Text));
  end;
  Repaint;
end;

//  
procedure TForm1.EditPicTxtChange(Sender: TObject);
begin
  Canvas.TextOut(40,60, EditPicTxt.Text);
  //   
  STxtWidth.Caption := IntToStr(Canvas.TextWidth(EditPicTxt.Text));
  STxtHeigth.Caption := IntToStr(Canvas.TextHeight(EditPicTxt.Text));
  Repaint;
end;

//  
procedure TForm1.FormCreate(Sender: TObject);
begin
   Canvas.Font.Size := 16;
   Canvas.Font.Color := RGB(128,255,255);
   //   
   STxtFontName.Caption := Canvas.Font.Name;
   STxtColor.Color := Canvas.Font.Color;
   STxtWidth.Caption := IntToStr(Canvas.TextWidth(EditPicTxt.Text));
   STxtHeigth.Caption := IntToStr(Canvas.TextHeight(EditPicTxt.Text));
end;

end.
